<?php

    $elementorLicenseKey = '';
    
    $settingModel = \CromurClient\Models\SettingsModel::select('*')->where('name', "=",
        \CromurClient\Models\SettingsModel::SETTING_ELEMENTOR_LICENSE_KEY)->getOneRow();
    if (! is_null($settingModel)) {
        $elementorLicenseKey = $settingModel->value;
    }
?>
<div class="container">
    <h1>
        <?php echo esc_html__('Cromur Settings', 'cromur-client-plugin'); ?>
    </h1>
    <hr class="mb-0">
    <?php require_once WP_PLUGIN_DIR . '/cromur-client/ui/views/html-blocks/menu.php'; ?>
    <hr class="mt-0">
</div>
<div class="container">
    <div class="alert alert-info">
        <?php echo esc_html__('Please for the optimal operation of the plugin define the settings below..',
            'cromur-client'); ?>
    </div>
    <?php $formUrl = admin_url() . 'admin.php?cromur_client_action=update-settings-form'; ?>
    <form method="post" id="settings-form" action="<?php echo $formUrl; ?>">
        <div style="display: none" class="alert alert-danger form-error-container"></div>
        <h6 class="mt-4 font-weight-bold">
            <?php echo esc_html__('Cromur Elementor', 'cromur-client'); ?>
        </h6>
        <hr class="mt-0">
        <div class="row">
            <div class="col-6">
                <label>
                        <span>
                            <?php echo esc_html__('License key', 'cromur-client'); ?>:
                        </span>
                </label>
                <div>
                    <input class="form-control required-control"
                           name="cromur-elementor-license-key" id="cromur-elementor-license-key"
                           type="text" value="<?php echo $elementorLicenseKey; ?>" />
                </div>
            </div>
        </div>



        <div class="row mt-3 form-btns-container">
            <div class="col-6">
                <button id="update-btn" class="btn btn-primary w-25"  type="button">
                    <?php echo esc_html__('Update', 'cromur-client'); ?>
                </button>
            </div>
            <div class="col-6">
                <?php $affiliatere_home_url = admin_url() . 'admin.php?cromur_client_action=go-home'; ?>
                <a class="btn btn-primary data-link" type="button"
                        href="#" data-end-point="<?php echo $affiliatere_home_url; ?>" id="return-btn">
                    <i class="fa fa-arrow-left"></i>
                    <?php echo esc_html__('Cancel', 'cromur-client'); ?>
                </a>
            </div>
        </div>
    </form>
</div>
<script type="text/javascript">
    jQuery(document).ready(function($) {
        var appMenu = $('#cromur-app-menu');
        appMenu.find('.nav-link').removeClass('font-weight-bold');
        appMenu.find('.btn-link').removeClass('font-weight-bold');
        appMenu.find('.settings-link').addClass('font-weight-bold');

        OloJsUi.processForm({
            formBtnId : '#update-btn',
            formId : '#settings-form',
            afterRequestSuccess : function (data) {
                if(typeof data === 'object'){
                    var contenu = '<div class="text-success">' + data.message +'</div>';
                    OloJsUi.showAlertDialog(contenu, function () {
                        $('#return-btn')[0].click();
                    });
                }
            }
        });

        OloJsUi.addDataLink('.data-link', '#ajax-requests-target');
    });
</script>

