<?php
    $elementorIsInstalled = false;
    $elementorProIsInstalled = false;

    $installationDate = '';
    $logModel =
        \CromurClient\Models\InstallationLogsModel::select()
            ->where('theme_plugin', '=', CromurClient\Models\InstallationLogsModel::APP_ELEMENTOR)->getOneRow();

    if (! is_null($logModel)) {
        $installationDate = date('d/m/Y', strtotime($logModel->creation_date));
    }

    if (file_exists(WP_PLUGIN_DIR . '/elementor')) {
        $elementorIsInstalled = true;
    }

    if (file_exists(WP_PLUGIN_DIR . '/elementor-pro')) {
        $elementorProIsInstalled = true;
    }
?>
<div class="alert alert-info">
    <?php echo esc_html__('Please select the theme/plugin you intend to activate from the list below. Click on the "Activate now" button and we will do the rest.', 'cromur_client-plugin'); ?>
</div>
<div class="row">
    <div class="col-sm">
        <?php if (($elementorIsInstalled && $elementorProIsInstalled)): ?>
            <div class="card" style="width: 20rem;">
                <img src="<?php echo plugins_url() . '/cromur-client/images/elementor_logo.png'; ?>" class="card-img-top" alt="...">
                <div class="card-body text-center">
                    <h5 class="card-title">Elementor</h5>
                    <?php if (strlen($installationDate) == 0): ?>
                        <button type="button" class="btn btn-primary btn-sm" id="activate-elementor-pro-btn"
                                data-end-point="<?php echo admin_url() . 'admin.php?cromur_client_action=activate-elementor'; ?>">
                            <?php echo esc_html__('Activate now', 'cromur_client-plugin'); ?>
                        </button>
                        <div id="activate-elementor-pro-btn-loading" class="mt-2 hidden">
                            <button class="btn btn-primary btn-sm" type="button" disabled>
                                <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                                <?php echo esc_html__('Activating...', 'cromur_client-plugin'); ?>
                            </button>
                        </div>
                        <div id="resp-cont" class="mt-2"></div>
                    <?php else: ?>
                        <div class="text-success font-weight-bold">
                            <?php echo esc_html__('Already activated', 'cromur_client-plugin'); ?>
                        </div>
                        <a href="<?php echo admin_url() . 'admin.php?cromur_client_action=reset-elementor-pro' ?>" class="btn btn-primary btn-sm mt-2">
                            <?php echo esc_html__('Reset license key', 'cromur_client-plugin'); ?>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        <?php else: ?>
            <div class="alert alert-warning">
                <?php echo esc_html__('It looks like either elementor or elementor pro is not installed. Please fix it below and reload page once completed. ', 'cromur_client-plugin'); ?>
                <button class="btn btn-primary btn-sm" type="button" onclick="Location.reload()">
                    <i class="fa fa-undo"></i>
                    <?php echo esc_html__('Reload', 'cromur_client-plugin'); ?>
                </button>
            </div>
            <?php if (! $elementorIsInstalled): ?>
                <a href="<?php echo admin_url() . 'plugin-install.php?s=elementor+website+builder&tab=search&type=term' ?>" class="btn btn-primary btn-sm" target="_blank">
                    <?php echo esc_html__('Install Elementor Website Builder', 'cromur_client-plugin'); ?>
                </a>
            <?php endif; ?>
            <?php if (! $elementorProIsInstalled): ?>
                <div>
                    <button type="button" class="btn btn-primary btn-sm" id="install-elementor-pro-btn"
                            data-end-point="<?php echo admin_url() . 'admin.php?cromur_client_action=install-elementor-pro' ?>">
                        <?php echo esc_html__('Install Elementor Pro', 'cromur_client-plugin'); ?>
                    </button>
                    <button class="btn btn-primary btn-sm d-none" id="install-elementor-pro-loading-btn" type="button" disabled>
                        <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                        <?php echo esc_html__('Installing...', 'cromur_client-plugin'); ?>
                    </button>
                    <div id="el-pro-install-resp" class="mt-2"></div>
                </div>
            <?php endif; ?>
        <?php endif; ?>
    </div>
    <div class="col-sm"></div>
</div>
<script type="text/javascript">
    jQuery(document).ready(function($) {
        $('#activate-elementor-pro-btn').click(function () {
            $(this).hide();
            var mainBtn = $(this);
            var loadingBtn = $('#activate-elementor-pro-btn-loading');
            var respCont = $('#resp-cont');
            respCont.empty();
            loadingBtn.removeClass('hidden');

            var url = $(this).attr('data-end-point');
            OloJsUi.sendGetRequest(url, '#resp-cont', function () {
                mainBtn.show();
                loadingBtn.addClass('hidden');
            }, false);
        });
        
        $('#install-elementor-pro-btn').click(function () {
            var mainBtn = $(this);
            $(this).hide();
            var loadingBtn = $('#install-elementor-pro-loading-btn');
            loadingBtn.removeClass('d-none');
            $('#el-pro-install-resp').empty();

            var url = $(this).attr('data-end-point');
            OloJsUi.sendGetRequest(url, '#el-pro-install-resp', function () {
                loadingBtn.addClass('d-none');
                mainBtn.show();
            }, false);
        });
    });
</script>