<?php

    if (file_exists(WP_PLUGIN_DIR . '/elementor-pro')) {
        echo 'Sorry but elementor pro is already installed.';
    } else {
        $elementorZipPath = WP_PLUGIN_DIR . '/cromur-client/bundles/elementor-pro-2.2.5.zip';

        $zip = new ZipArchive;
        if ($zip->open($elementorZipPath) === true) {
            $zip->extractTo(WP_PLUGIN_DIR);
            $zip->close();
            $activationLink = admin_url() .
                'plugins.php?action=activate&plugin=elementor-pro%2Felementor-pro.php&plugin_status=all&paged=1&s';
            $activationLink = wp_nonce_url($activationLink, 'activate-plugin_elementor-pro/elementor-pro.php');
            $msg = '<div class="text-success">';
            $msg .= 'Elementor Pro was installed. ';
            $msg .= '<a href="' . $activationLink . '" class="btn btn-primary btn-sm" target="_blank">Activate it</a>';
            $msg .= '</div>';
            echo $msg;
        } else {
            $msg = '<div class="text-danger">';
            $msg .= 'Elementor Pro installation failed.';
            $msg .= '</div>';
            echo $msg;
        }

    }