<?php

namespace MartianooCore\Api\Database;


/**
 * This class represents an attribute of a column in a database table.
 * @package MartianooCore\Api\Database
 */
class Attrib
{
    private $attribues = "";

    private $foreignKeyOnUpdate = "";

    private $foreignKeyOnDelete = "";

    private $unsignedAttribute = "";
    private $notNullAttribute = "";

    const FOREIGN_KEY_CASCADE = "CASCADE";

    const FOREIGN_KEY_RESTRICT = "RESTRICT";
    const FOREIGN_KEY_SET_NULL = "SET NULL";
    const FOREIGN_KEY_NO_ACTION = "NO ACTION";
    const FOREIGN_KEY_SET_DEFAULT = "SET DEFAULT";

    /**
     * Adds the UNIQUE attribute and returns an instance of Attrib for chained calls.
     * @return Attrib
     */
    public function unique()
    {
        $test = preg_match("/unique/i", $this->attribues);
        if (! $test) {
            $this->attribues .= " UNIQUE";
        }

        return $this;
    }

    /**
     * Adds the NOT NULL attribute and returns an instance of Attrib for chained calls.
     * @return Attrib
     */
    public function notNull()
    {
        $this->notNullAttribute = " NOT NULL";

        return $this;
    }

    /**
     * Adds the UNSIGNED attribute and returns an instance of Attrib for chained calls.
     * @return Attrib
     */
    public function unsigned()
    {
        $this->unsignedAttribute = " UNSIGNED";

        return $this;
    }

    /**
     * Adds the DEFAULT attribute and returns an instance of Attrib for chained calls.
     * @return Attrib
     */
    public function defaultValue($value)
    {
        $test = preg_match("/default/i", $this->attribues);
        if (! $test) {
            $this->attribues .= " DEFAULT '" .$value . "'";
        }

        return $this;
    }

    /**
     * Adds the ON UPDATE keyword to the attribute of a foreign key and returns an instance of Attrib for chained calls.
     * @param string $referenceOption the reference option on update. Allowed values : **RESTRICT | CASCADE | SET NULL | NO ACTION | SET DEFAULT**.
     * The default value is **CASCADE**
     * @return Attrib
     */
    public function onUpdate($referenceOption = self::FOREIGN_KEY_CASCADE)
    {
        $allowedRefs = [self::FOREIGN_KEY_RESTRICT, self::FOREIGN_KEY_CASCADE,
            self::FOREIGN_KEY_SET_NULL, self::FOREIGN_KEY_NO_ACTION, self::FOREIGN_KEY_SET_DEFAULT];


        $this->foreignKeyOnUpdate = " ON UPDATE " . $referenceOption;
        return $this;
    }

    /**
     * Adds the ON DELETE keyword to the attribute of a foreign key and returns an instance of Attrib for chained calls.
     * @param string $referenceOption the reference option on delete. Allowed values : **RESTRICT | CASCADE | SET NULL | NO ACTION | SET DEFAULT**.
     * The default value is **CASCADE**
     * @return Attrib
     */
    public function onDelete($referenceOption = "CASCADE")
    {
        $this->foreignKeyOnDelete = " ON DELETE " . $referenceOption;
        return $this;
    }



    /**
     * Returns a string containing all the attributes added, each attribute is preceded by a white space.
     * @return string
     */
    public function toString()
    {
        $test = preg_match("/unsigned/i", $this->attribues);
        if (strlen($this->unsignedAttribute) > 0 && ! $test) {
            $this->attribues .= $this->unsignedAttribute;
        }

        $test = preg_match("/not\\snull/i", $this->attribues);
        if (strlen($this->notNullAttribute) > 0 && ! $test) {
            $this->attribues .= $this->notNullAttribute;
        }

        if (strlen($this->attribues) > 0) {
            return $this->attribues;
        } else {
            return $this->foreignKeyOnUpdate . $this->foreignKeyOnDelete;
        }
    }


}