<?php

    $controls = [];

    if (! isset($_POST['cromur-elementor-license-key']) || ! is_string($_POST['cromur-elementor-license-key']) ||
        strlen($_POST['cromur-elementor-license-key']) == 0) {
        $controls['cromur-elementor-license-key'] = esc_html__('Invalid license key',
            'cromom-server');
    }

    if (count($controls) > 0) {
        $response['message'] = esc_html__('Please errors were detected in the values you submited.',
            'cromom-client');

        $response['controles'] = $controls;
        wp_send_json($response, 400);
        exit;
    }

    $settingModel = \CromurClient\Models\SettingsModel::select('*')->where('name', "=",
        \CromurClient\Models\SettingsModel::SETTING_ELEMENTOR_LICENSE_KEY)->getOneRow();
    if (! is_null($settingModel)) {
        $settingModel->value = $_POST['cromur-elementor-license-key'];
        $settingModel->save();
    } else {
        $settingModel = new \CromurClient\Models\SettingsModel();
        $settingModel->name = \CromurClient\Models\SettingsModel::SETTING_ELEMENTOR_LICENSE_KEY;
        $settingModel->value = $_POST['cromur-elementor-license-key'];
        $settingModel->save();
    }



    wp_send_json([
        "message" => esc_html__('Settings were successfully modified.',
            'cromom-server')
    ], 200);