<?php if($nbOfPages > 1){ ?>
    <div class="row paginators">
        <?php
        $currentPage = 0;
        if(isset($_GET['_page']) && is_string($_GET['_page']) && (integer) $_GET['_page'] <= $nbOfPages){
            $currentPage = (integer) $_GET['_page'];
        } elseif (!isset($_GET['_page'])) {
            $currentPage = 1;
        }
        ?>
        <div class="col">
            <div class="float-left mr-3">
                <a href="#paginators-anchor" class="pagination-link data-link first-arrow"
                   data-end-point="<?php echo $baseUrl . '&_page=1'; ?>">
                    <i class="fa fa-angle-double-left"></i>
                </a>
            </div>
            <div class="float-left mr-3">
                <select class="pages-list">
                    <?php for ($i = 1; $i <= $nbOfPages; $i++): ?>
                        <?php
                        $selectedAttr = '';
                        if ($i == $currentPage) {
                            $selectedAttr = 'selected="selected"';
                        }
                        ?>
                        <option value="<?php echo $i; ?>" <?php echo $selectedAttr;?>>
                            page <?php echo $i; ?>
                        </option>
                    <?php endfor; ?>
                </select>
                <a href="#paginators-anchor" class="hidden goto-title-link"></a>
            </div>
            <?php if($currentPage > 1): ?>
                <div class="float-left mr-3">
                    <a href="#paginators-anchor" class="pagination-link data-link"
                       data-end-point="<?php echo $baseUrl . '&_page=' . ($currentPage - 1); ?>">
                        <i class="fa fa-angle-left"></i>
                    </a>
                </div>
            <?php endif; ?>
            <?php if($currentPage < $nbOfPages): ?>
                <div class="float-left mr-3">
                    <a href="#paginators-anchor" class="pagination-link data-link"
                       data-end-point="<?php echo $baseUrl . '&_page=' . ($currentPage + 1); ?>">
                        <i class="fa fa-angle-right"></i>
                    </a>
                </div>
            <?php endif; ?>
            <div class="float-left mr-3">
                <a href="#paginators-anchor" class="pagination-link data-link last-arrow"
                   data-end-point="<?php echo $baseUrl . '&_page=' . $nbOfPages; ?>">
                    <i class="fa fa-angle-double-right"></i>
                </a>
            </div>
            <?php if($currentPage > 0){ ?>
                <div class="float-left mr-5">
                    page
                    <?php echo $currentPage; ?>
                    /
                    <?php echo $nbOfPages; ?>
                </div>
            <?php } ?>
        </div>
    </div>
    <script type="text/javascript">
        jQuery(document).ready(function($) {
            var paginators = $('.paginators');
            paginators.find('.pages-list').on('change', function () {
                var selectedPage = $(this).val();
                var firstArrowUrl = paginators.find('.first-arrow').first().attr('data-end-point') + '';
                var newPageUrl = firstArrowUrl.replace(/_page=[0-9]+/, '_page=' + selectedPage);
                $('.goto-title-link').first()[0].click();

                OloJsUi.sendGetRequest(newPageUrl, '#ajax-requests-target');
            });
        });
    </script>
<?php } ?>
