<?php

namespace CromurClient\Tables;


use MartianooCore\Api\Database\Table;

class AllTables extends Table
{
    public function create()
    {
        $tables = [
            new SettingsTable(),
            new InstallationLogsTable(),
        ];

        foreach ($tables as $table) {
            try {
                $table->create();
            } catch (\Exception $exception) {
                if (! preg_match('/exists/', $exception->getMessage())) {
                    throw $exception;
                }
            }
        }

        return true;
    }


    public function drop()
    {
        $tables = [
            new SettingsTable(),
            new InstallationLogsTable(),
        ];

        foreach ($tables as $table) {
            $table->drop();
        }

        return true;
    }
}