<?php

namespace CromurClient;

class WebServer
{
    private $endPoint;
    private $curlResource;

    function __construct($endPointUrl, $verifySslHost = true, $verifySslPeer = true, $userAgent = '')
    {
        $this->endPoint = $endPointUrl;
        $this->curlResource = curl_init();
        $this->verifySslHost = $verifySslHost;
        $this->verifySslPeer = $verifySslPeer;
        $this->userAgent = $userAgent;
    }

    public function executeGetRequest($cookies = '')
    {
        $this->prepareRequest();

        if (is_string($cookies) && strlen($cookies) > 0) {
            curl_setopt($this->curlResource, CURLOPT_COOKIE, $cookies);
        }

        $result = curl_exec($this->curlResource);

        if(!is_bool($result)){
            return $result;
        }else{
            $msg = curl_error($this->curlResource);
            throw new \Exception($msg);
        }
    }

    public function executePostRequest($data, $cookies = '')
    {
        $this->prepareRequest();

        if (is_string($cookies) && strlen($cookies) > 0) {
            curl_setopt($this->curlResource, CURLOPT_COOKIE, $cookies);
        }

        curl_setopt($this->curlResource, CURLOPT_POST, 1);
        curl_setopt($this->curlResource, CURLOPT_POSTFIELDS, $data);

        $result = curl_exec($this->curlResource);

        if(!is_bool($result)){
            return $result;
        }else{
            $msg = curl_error($this->curlResource);
            throw new \Exception($msg);
        }
    }

    public function getLastHttpResponseCode()
    {
        if(is_resource($this->curlResource)){
            return (int) curl_getinfo($this->curlResource, CURLINFO_HTTP_CODE);
        }

        return false;
    }

    public function getLastHttpResponseContentType()
    {
        if(is_resource($this->curlResource)){
            return curl_getinfo($this->curlResource, CURLINFO_CONTENT_TYPE);
        }

        return null;
    }

    /**
     * @param mixed $newUrl
     */
    public function setUrl($newUrl)
    {
        $this->endPoint = $newUrl;
    }
    

    public function __destruct()
    {
        if(is_resource($this->curlResource))
            curl_close($this->curlResource);
    }


    private function prepareRequest()
    {
        if (! is_string($this->userAgent) || strlen($this->userAgent) == 0) {
            $this->userAgent = $this->getUserAgentName();
        }

        curl_setopt($this->curlResource, CURLOPT_URL, $this->endPoint);
        curl_setopt($this->curlResource, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($this->curlResource, CURLOPT_FOLLOWLOCATION, true);
        //curl_setopt($this->curlResource, CURLOPT_MAXREDIRS, 1);
        curl_setopt($this->curlResource, CURLOPT_SSL_VERIFYHOST, $this->verifySslHost);
        curl_setopt($this->curlResource, CURLOPT_SSL_VERIFYPEER, $this->verifySslPeer);
        curl_setopt($this->curlResource, CURLOPT_USERAGENT, $this->userAgent);
        curl_setopt($this->curlResource,CURLOPT_TIMEOUT,90000);
    }

    private function getUserAgentName()
    {
        $randKey = rand(0, 1);
        $userAgents = [
            'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:48.0) Gecko/20100101 Firefox/48.0',
            'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36',
        ];

        return $userAgents[$randKey];
    }
}