<?php
/*
Plugin Name: Cromur Client
Plugin URI: #
Description: <p>A plugin that collaborates with its server counterpart to share themes' licenses (elementor, astratheme, generatepro, schemapro) with WordPress's sites owners</p>
Version: 1.0.0
Author: OLOMO Claude
Author URI: #
License: GLv2
*/

require_once __DIR__ . "/vendor/autoload.php";

add_action( 'admin_init', 'mco_cromur_client_backend_page_ajax');
add_action( 'admin_init', 'mco_cromur_client_settings_form');
add_action( 'admin_init', 'mco_cromur_client_update_settings');
add_action( 'admin_init', 'mco_cromur_client_install_elementor_pro');
add_action( 'admin_init', 'mco_cromur_client_activate_elementor_pro');
add_action( 'admin_init', 'mco_cromur_client_reset_elemetor_pro');

add_action( 'admin_init', 'mco_cromur_client_frontend_files');


register_activation_hook(__FILE__, 'mco_cromur_client_initialization');
function mco_cromur_client_initialization(){
    $allTables = new \CromurClient\Tables\AllTables();

    try {
        //$allTables->drop();
        $allTables->create();
    } catch (\Exception $exception) {
        throw $exception;
    }
}

register_uninstall_hook(__FILE__, 'mco_cromur_client_uninstall');
function mco_cromur_client_uninstall(){
    $allTables = new \CromurClient\Tables\AllTables();

    try {
        $allTables->drop();
    } catch (\Exception $exception) {
        throw $exception;
    }
}

// Add a menu for our option page
add_action('admin_menu', 'mco_cromur_client_add_pages');
function mco_cromur_client_add_pages() {
    add_menu_page('Cromur client', 'Cromur client', 'add_users', 'cromur_client_home',
        'mco_cromur_client_backend_page', null, 6);
}

function mco_cromur_client_backend_page(){
    require_once __DIR__  . '/ui/views/home.php';
}

function mco_cromur_client_backend_page_ajax(){
    if(isset($_GET['cromur_client_action']) && $_GET['cromur_client_action'] == 'go-home') {
        require_once __DIR__  . '/ui/views/home-ajax.php';
        exit;
    }
}

function mco_cromur_client_settings_form(){
    if(isset($_GET['cromur_client_action']) && $_GET['cromur_client_action'] == 'settings-form') {
        require_once __DIR__ . '/ui/views/settings-form.php';
        exit;
    }
}

function mco_cromur_client_update_settings(){
    if(isset($_GET['cromur_client_action']) && $_GET['cromur_client_action'] == 'update-settings-form') {
        require_once __DIR__ . '/ui/actions/update-settings.php';
        exit;
    }
}

function mco_cromur_client_install_elementor_pro(){
    if(isset($_GET['cromur_client_action']) && $_GET['cromur_client_action'] == 'install-elementor-pro') {
        require_once __DIR__ . '/ui/actions/install-elementor-pro.php';
        exit;
    }
}

function mco_cromur_client_activate_elementor_pro(){
    if(isset($_GET['cromur_client_action']) && $_GET['cromur_client_action'] == 'activate-elementor') {
        require_once __DIR__ . '/ui/actions/activate-elementor-pro.php';
        exit;
    }
}

function mco_cromur_client_reset_elemetor_pro(){
    if(isset($_GET['cromur_client_action']) && $_GET['cromur_client_action'] == 'reset-elementor-pro') {
        require_once __DIR__ . '/ui/actions/reset-elementor-pro.php';
        exit;
    }
}



function mco_cromur_client_frontend_files() {
    if(is_admin() && preg_match('/cromur_client/i', $_SERVER['REQUEST_URI'])){
        wp_enqueue_style('jquery-ui.min.css',
            plugins_url() . '/cromur-client/css/jquery-ui.min.css');
        wp_enqueue_style('cromur-client.css',
            plugins_url() . '/cromur-client/css/cromur_client.css');
        wp_enqueue_style('fontawesome-all.min.css',
            plugins_url() . '/cromur-client/css/fontawesome-all.min.css');
        wp_enqueue_style('bootstrap.min.css',
            plugins_url() . '/cromur-client/css/bootstrap.min.css');
        wp_enqueue_style('ui-library',
            plugins_url() . '/cromur-client/css/ui-library.css');


        wp_enqueue_script( 'jquery-ui.min', plugins_url() . '/cromur-client/js/jquery-ui.min.js', array('jquery'));
        wp_enqueue_script( 'cromur', plugins_url() . '/cromur-client/js/cromur.js', array('jquery-ui.min'));
        wp_enqueue_script( 'assign-dollar-sign', plugins_url() . '/cromur-client/js/assign-dollar-sign.js', array('jquery-ui.min'));
        wp_enqueue_script( 'ui-library', plugins_url() . '/cromur-client/js/ui-library.js', array('assign-dollar-sign'));
        wp_enqueue_script( 'bootstrap.bundle.min', plugins_url() . '/cromur-client/js/bootstrap.bundle.min.js');
    }
}
